"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    core_device_thing_name: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a paginated list of client devices that are associated with a core device.

    Args:
        core_device_thing_name(str): The name of the core device. This is also the name of the IoT thing.
        max_results(int, optional): The maximum number of results to be returned per paginated request. Defaults to None.
        next_token(str, optional): The token to be used for the next set of paginated results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.client_device_associated_with_core_device.list(
                ctx, core_device_thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.client_device_associated_with_core_device.list core_device_thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="list_client_devices_associated_with_core_device",
        op_kwargs={
            "coreDeviceThingName": core_device_thing_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
