"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, core_device_thing_name: str, entries: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Associate a list of client devices with a core device. Use this API operation to specify which client devices can discover a core device through cloud discovery. With cloud discovery, client devices connect to IoT Greengrass to retrieve associated core devices' connectivity information and certificates. For more information, see Configure cloud discovery in the IoT Greengrass V2 Developer Guide.  Client devices are local IoT devices that connect to and communicate with an IoT Greengrass core device over MQTT. You can connect client devices to a core device to sync MQTT messages and data to Amazon Web Services IoT Core and interact with client devices in Greengrass components. For more information, see Interact with local IoT devices in the IoT Greengrass V2 Developer Guide.

    Args:
        entries(List, optional): The list of client devices to associate. Defaults to None.
        core_device_thing_name(str): The name of the core device. This is also the name of the IoT thing.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrassv2.associate_client_device_with_core_device.batch(
                ctx, core_device_thing_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrassv2.associate_client_device_with_core_device.batch core_device_thing_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrassv2",
        operation="batch_associate_client_device_with_core_device",
        op_kwargs={"entries": entries, "coreDeviceThingName": core_device_thing_name},
    )
