"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    subscription_definition_id: str,
    amzn_client_token: str = None,
    subscriptions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of a subscription definition which has already been defined.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        subscription_definition_id(str): The ID of the subscription definition.
        subscriptions(List, optional): A list of subscriptions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.subscription_definition.version.create(
                ctx, subscription_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.subscription_definition.version.create subscription_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_subscription_definition_version",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "SubscriptionDefinitionId": subscription_definition_id,
            "Subscriptions": subscriptions,
        },
    )


async def get(
    hub,
    ctx,
    subscription_definition_id: str,
    subscription_definition_version_id: str,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a subscription definition version.

    Args:
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.
        subscription_definition_id(str): The ID of the subscription definition.
        subscription_definition_version_id(str): The ID of the subscription definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListSubscriptionDefinitionVersions'' requests. If the version is the last one that was associated with a subscription definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.subscription_definition.version.get(
                ctx, subscription_definition_id=value, subscription_definition_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.subscription_definition.version.get subscription_definition_id=value, subscription_definition_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_subscription_definition_version",
        op_kwargs={
            "NextToken": next_token,
            "SubscriptionDefinitionId": subscription_definition_id,
            "SubscriptionDefinitionVersionId": subscription_definition_version_id,
        },
    )


async def list_all(
    hub,
    ctx,
    subscription_definition_id: str,
    max_results: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a subscription definition.

    Args:
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.
        subscription_definition_id(str): The ID of the subscription definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.subscription_definition.version.list_all(
                ctx, subscription_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.subscription_definition.version.list_all subscription_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_subscription_definition_versions",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "SubscriptionDefinitionId": subscription_definition_id,
        },
    )
