"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    s3_url_signer_role: str,
    software_to_update: str,
    update_targets: List,
    update_targets_architecture: str,
    update_targets_operating_system: str,
    amzn_client_token: str = None,
    update_agent_log_level: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional commands to manage a Greengrass core software update job.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        s3_url_signer_role(str): The IAM Role that Greengrass will use to create pre-signed URLs pointing towards the update artifact.
        software_to_update(str): The piece of software on the Greengrass core that will be updated.
        update_agent_log_level(str, optional): The minimum level of log statements that should be logged by the OTA Agent during an update. Defaults to None.
        update_targets(List): The ARNs of the targets (IoT things or IoT thing groups) that this update will be applied to.
        update_targets_architecture(str): The architecture of the cores which are the targets of an update.
        update_targets_operating_system(str): The operating system of the cores which are the targets of an update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.software_update_job.create(
                ctx,
                s3_url_signer_role=value,
                software_to_update=value,
                update_targets=value,
                update_targets_architecture=value,
                update_targets_operating_system=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.software_update_job.create s3_url_signer_role=value, software_to_update=value, update_targets=value, update_targets_architecture=value, update_targets_operating_system=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_software_update_job",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "S3UrlSignerRole": s3_url_signer_role,
            "SoftwareToUpdate": software_to_update,
            "UpdateAgentLogLevel": update_agent_log_level,
            "UpdateTargets": update_targets,
            "UpdateTargetsArchitecture": update_targets_architecture,
            "UpdateTargetsOperatingSystem": update_targets_operating_system,
        },
    )
