"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, role_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in the policy ''AWSGreengrassResourceAccessRolePolicy''.

    Args:
        role_arn(str): The ARN of the service role you wish to associate with your account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.service_role.to_account.associate(
                ctx, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.service_role.to_account.associate role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="associate_service_role_to_account",
        op_kwargs={"RoleArn": role_arn},
    )
