"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the service role from your account. Without a service role, deployments will not work.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.service_role.from_account.disassociate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.service_role.from_account.disassociate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="disassociate_service_role_from_account",
        op_kwargs={},
    )
