"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the service role that is attached to your account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.service_role.for_account.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.service_role.for_account.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_service_role_for_account",
        op_kwargs={},
    )
