"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, group_id: str, role_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's permissions should allow Greengrass core Lambda functions to perform actions against the cloud.

    Args:
        group_id(str): The ID of the Greengrass group.
        role_arn(str): The ARN of the role you wish to associate with this group. The existence of the role is not validated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.role.to_group.associate(
                ctx, group_id=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.role.to_group.associate group_id=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="associate_role_to_group",
        op_kwargs={"GroupId": group_id, "RoleArn": role_arn},
    )
