"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the role from a group.

    Args:
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.role.from_group.disassociate(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.role.from_group.disassociate group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="disassociate_role_from_group",
        op_kwargs={"GroupId": group_id},
    )
