"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    resource_definition_id: str,
    amzn_client_token: str = None,
    resources: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of a resource definition that has already been defined.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        resource_definition_id(str): The ID of the resource definition.
        resources(List, optional): A list of resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.resource.definition.version.create(
                ctx, resource_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.resource.definition.version.create resource_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_resource_definition_version",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "ResourceDefinitionId": resource_definition_id,
            "Resources": resources,
        },
    )


async def get(
    hub, ctx, resource_definition_id: str, resource_definition_version_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a resource definition version, including which resources are included in the version.

    Args:
        resource_definition_id(str): The ID of the resource definition.
        resource_definition_version_id(str): The ID of the resource definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListResourceDefinitionVersions'' requests. If the version is the last one that was associated with a resource definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.resource.definition.version.get(
                ctx, resource_definition_id=value, resource_definition_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.resource.definition.version.get resource_definition_id=value, resource_definition_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_resource_definition_version",
        op_kwargs={
            "ResourceDefinitionId": resource_definition_id,
            "ResourceDefinitionVersionId": resource_definition_version_id,
        },
    )


async def list_all(
    hub,
    ctx,
    resource_definition_id: str,
    max_results: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a resource definition.

    Args:
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.
        resource_definition_id(str): The ID of the resource definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.resource.definition.version.list_all(
                ctx, resource_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.resource.definition.version.list_all resource_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_resource_definition_versions",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "ResourceDefinitionId": resource_definition_id,
        },
    )
