"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    amzn_client_token: str = None,
    initial_version: Dict = None,
    name: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a resource definition which contains a list of resources to be used in a group. You can create an initial version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        initial_version(Dict, optional): Information about the initial version of the resource definition. Defaults to None.
        name(str, optional): The name of the resource definition. Defaults to None.
        tags(Dict, optional): Tag(s) to add to the new resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.resource.definition.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.resource.definition.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_resource_definition",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "InitialVersion": initial_version,
            "Name": name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, resource_definition_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a resource definition.

    Args:
        resource_definition_id(str): The ID of the resource definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.resource.definition.init.delete(
                ctx, resource_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.resource.definition.init.delete resource_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="delete_resource_definition",
        op_kwargs={"ResourceDefinitionId": resource_definition_id},
    )


async def get(hub, ctx, resource_definition_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a resource definition, including its creation time and latest version.

    Args:
        resource_definition_id(str): The ID of the resource definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.resource.definition.init.get(
                ctx, resource_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.resource.definition.init.get resource_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_resource_definition",
        op_kwargs={"ResourceDefinitionId": resource_definition_id},
    )


async def list_all(hub, ctx, max_results: str = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of resource definitions.

    Args:
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.resource.definition.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.resource.definition.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_resource_definitions",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, resource_definition_id: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a resource definition.

    Args:
        name(str, optional): The name of the definition. Defaults to None.
        resource_definition_id(str): The ID of the resource definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.resource.definition.init.update(
                ctx, resource_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.resource.definition.init.update resource_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="update_resource_definition",
        op_kwargs={"Name": name, "ResourceDefinitionId": resource_definition_id},
    )
