"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    group_id: str,
    amzn_client_token: str = None,
    connector_definition_version_arn: str = None,
    core_definition_version_arn: str = None,
    device_definition_version_arn: str = None,
    function_definition_version_arn: str = None,
    logger_definition_version_arn: str = None,
    resource_definition_version_arn: str = None,
    subscription_definition_version_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of a group which has already been defined.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        connector_definition_version_arn(str, optional): The ARN of the connector definition version for this group. Defaults to None.
        core_definition_version_arn(str, optional): The ARN of the core definition version for this group. Defaults to None.
        device_definition_version_arn(str, optional): The ARN of the device definition version for this group. Defaults to None.
        function_definition_version_arn(str, optional): The ARN of the function definition version for this group. Defaults to None.
        group_id(str): The ID of the Greengrass group.
        logger_definition_version_arn(str, optional): The ARN of the logger definition version for this group. Defaults to None.
        resource_definition_version_arn(str, optional): The ARN of the resource definition version for this group. Defaults to None.
        subscription_definition_version_arn(str, optional): The ARN of the subscription definition version for this group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.version.create(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.version.create group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_group_version",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "ConnectorDefinitionVersionArn": connector_definition_version_arn,
            "CoreDefinitionVersionArn": core_definition_version_arn,
            "DeviceDefinitionVersionArn": device_definition_version_arn,
            "FunctionDefinitionVersionArn": function_definition_version_arn,
            "GroupId": group_id,
            "LoggerDefinitionVersionArn": logger_definition_version_arn,
            "ResourceDefinitionVersionArn": resource_definition_version_arn,
            "SubscriptionDefinitionVersionArn": subscription_definition_version_arn,
        },
    )


async def get(hub, ctx, group_id: str, group_version_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a group version.

    Args:
        group_id(str): The ID of the Greengrass group.
        group_version_id(str): The ID of the group version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListGroupVersions'' requests. If the version is the last one that was associated with a group, the value also maps to the ''LatestVersion'' property of the corresponding ''GroupInformation'' object.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.version.get(
                ctx, group_id=value, group_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.version.get group_id=value, group_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_group_version",
        op_kwargs={"GroupId": group_id, "GroupVersionId": group_version_id},
    )


async def list_all(
    hub, ctx, group_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a group.

    Args:
        group_id(str): The ID of the Greengrass group.
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.version.list_all(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.version.list_all group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_group_versions",
        op_kwargs={
            "GroupId": group_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
