"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    amzn_client_token: str = None,
    initial_version: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time. Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a library or command-line application to create and deploy Greengrass groups.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        initial_version(Dict, optional): Information about the initial version of the group. Defaults to None.
        name(str): The name of the group.
        tags(Dict, optional): Tag(s) to add to the new resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_group",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "InitialVersion": initial_version,
            "Name": name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a group.

    Args:
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.init.delete(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.init.delete group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="delete_group",
        op_kwargs={"GroupId": group_id},
    )


async def get(hub, ctx, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a group.

    Args:
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.init.get(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.init.get group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_group",
        op_kwargs={"GroupId": group_id},
    )


async def list_all(hub, ctx, max_results: str = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of groups.

    Args:
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_groups",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, group_id: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a group.

    Args:
        group_id(str): The ID of the Greengrass group.
        name(str, optional): The name of the definition. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.init.update(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.init.update group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="update_group",
        op_kwargs={"GroupId": group_id, "Name": name},
    )
