"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current configuration for the CA used by the group.

    Args:
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.certificate.configuration.get(
                ctx, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.certificate.configuration.get group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_group_certificate_configuration",
        op_kwargs={"GroupId": group_id},
    )


async def update(
    hub, ctx, group_id: str, certificate_expiry_in_milliseconds: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Certificate expiry time for a group.

    Args:
        certificate_expiry_in_milliseconds(str, optional): The amount of time remaining before the certificate expires, in milliseconds. Defaults to None.
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.certificate.configuration.update(
                ctx, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.certificate.configuration.update group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="update_group_certificate_configuration",
        op_kwargs={
            "CertificateExpiryInMilliseconds": certificate_expiry_in_milliseconds,
            "GroupId": group_id,
        },
    )
