"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, group_id: str, amzn_client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a CA for the group. If a CA already exists, it will rotate the existing CA.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.certificate.authority.create(
                ctx, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.certificate.authority.create group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_group_certificate_authority",
        op_kwargs={"AmznClientToken": amzn_client_token, "GroupId": group_id},
    )


async def get(hub, ctx, certificate_authority_id: str, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retreives the CA associated with a group. Returns the public key of the CA.

    Args:
        certificate_authority_id(str): The ID of the certificate authority.
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.certificate.authority.get(
                ctx, certificate_authority_id=value, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.certificate.authority.get certificate_authority_id=value, group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_group_certificate_authority",
        op_kwargs={
            "CertificateAuthorityId": certificate_authority_id,
            "GroupId": group_id,
        },
    )


async def list_all(hub, ctx, group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current CAs for a group.

    Args:
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.group.certificate.authority.list_all(
                ctx, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.group.certificate.authority.list_all group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_group_certificate_authorities",
        op_kwargs={"GroupId": group_id},
    )
