"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    function_definition_id: str,
    amzn_client_token: str = None,
    default_config: Dict = None,
    functions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of a Lambda function definition that has already been defined.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        default_config(Dict, optional): The default configuration that applies to all Lambda functions in this function definition version. Individual Lambda functions can override these settings. Defaults to None.
        function_definition_id(str): The ID of the Lambda function definition.
        functions(List, optional): A list of Lambda functions in this function definition version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.function_definition.version.create(
                ctx, function_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.function_definition.version.create function_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_function_definition_version",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "DefaultConfig": default_config,
            "FunctionDefinitionId": function_definition_id,
            "Functions": functions,
        },
    )


async def get(
    hub,
    ctx,
    function_definition_id: str,
    function_definition_version_id: str,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a Lambda function definition version, including which Lambda functions are included in the version and their configurations.

    Args:
        function_definition_id(str): The ID of the Lambda function definition.
        function_definition_version_id(str): The ID of the function definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListFunctionDefinitionVersions'' requests. If the version is the last one that was associated with a function definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.function_definition.version.get(
                ctx, function_definition_id=value, function_definition_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.function_definition.version.get function_definition_id=value, function_definition_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_function_definition_version",
        op_kwargs={
            "FunctionDefinitionId": function_definition_id,
            "FunctionDefinitionVersionId": function_definition_version_id,
            "NextToken": next_token,
        },
    )


async def list_all(
    hub,
    ctx,
    function_definition_id: str,
    max_results: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a Lambda function definition.

    Args:
        function_definition_id(str): The ID of the Lambda function definition.
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.function_definition.version.list_all(
                ctx, function_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.function_definition.version.list_all function_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_function_definition_versions",
        op_kwargs={
            "FunctionDefinitionId": function_definition_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
