"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    device_definition_id: str,
    amzn_client_token: str = None,
    devices: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of a device definition that has already been defined.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        device_definition_id(str): The ID of the device definition.
        devices(List, optional): A list of devices in the definition version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.device_definition.version.create(
                ctx, device_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.device_definition.version.create device_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_device_definition_version",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "DeviceDefinitionId": device_definition_id,
            "Devices": devices,
        },
    )


async def get(
    hub,
    ctx,
    device_definition_id: str,
    device_definition_version_id: str,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a device definition version.

    Args:
        device_definition_id(str): The ID of the device definition.
        device_definition_version_id(str): The ID of the device definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListDeviceDefinitionVersions'' requests. If the version is the last one that was associated with a device definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.device_definition.version.get(
                ctx, device_definition_id=value, device_definition_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.device_definition.version.get device_definition_id=value, device_definition_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_device_definition_version",
        op_kwargs={
            "DeviceDefinitionId": device_definition_id,
            "DeviceDefinitionVersionId": device_definition_version_id,
            "NextToken": next_token,
        },
    )


async def list_all(
    hub, ctx, device_definition_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a device definition.

    Args:
        device_definition_id(str): The ID of the device definition.
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.device_definition.version.list_all(
                ctx, device_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.device_definition.version.list_all device_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_device_definition_versions",
        op_kwargs={
            "DeviceDefinitionId": device_definition_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
