"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    deployment_type: str,
    group_id: str,
    amzn_client_token: str = None,
    deployment_id: str = None,
    group_version_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token'' token and the request parameters.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        deployment_id(str, optional): The ID of the deployment if you wish to redeploy a previous deployment. Defaults to None.
        deployment_type(str): The type of deployment. When used for ''CreateDeployment'', only ''NewDeployment'' and ''Redeployment'' are valid.
        group_id(str): The ID of the Greengrass group.
        group_version_id(str, optional): The ID of the group version to be deployed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.deployment.init.create(
                ctx, deployment_type=value, group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.deployment.init.create deployment_type=value, group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_deployment",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "DeploymentId": deployment_id,
            "DeploymentType": deployment_type,
            "GroupId": group_id,
            "GroupVersionId": group_version_id,
        },
    )


async def list_all(
    hub, ctx, group_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a history of deployments for the group.

    Args:
        group_id(str): The ID of the Greengrass group.
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.deployment.init.list_all(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.deployment.init.list_all group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_deployments",
        op_kwargs={
            "GroupId": group_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def reset(
    hub, ctx, group_id: str, amzn_client_token: str = None, force: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Resets a group's deployments.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        force(bool, optional): If true, performs a best-effort only core reset. Defaults to None.
        group_id(str): The ID of the Greengrass group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.deployment.init.reset(ctx, group_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.deployment.init.reset group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="reset_deployments",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "Force": force,
            "GroupId": group_id,
        },
    )
