"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, core_definition_id: str, amzn_client_token: str = None, cores: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly one Greengrass core.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        core_definition_id(str): The ID of the core definition.
        cores(List, optional): A list of cores in the core definition version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.core_definition.version.create(
                ctx, core_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.core_definition.version.create core_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_core_definition_version",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "CoreDefinitionId": core_definition_id,
            "Cores": cores,
        },
    )


async def get(
    hub, ctx, core_definition_id: str, core_definition_version_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a core definition version.

    Args:
        core_definition_id(str): The ID of the core definition.
        core_definition_version_id(str): The ID of the core definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListCoreDefinitionVersions'' requests. If the version is the last one that was associated with a core definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.core_definition.version.get(
                ctx, core_definition_id=value, core_definition_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.core_definition.version.get core_definition_id=value, core_definition_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_core_definition_version",
        op_kwargs={
            "CoreDefinitionId": core_definition_id,
            "CoreDefinitionVersionId": core_definition_version_id,
        },
    )


async def list_all(
    hub, ctx, core_definition_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a core definition.

    Args:
        core_definition_id(str): The ID of the core definition.
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.core_definition.version.list_all(
                ctx, core_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.core_definition.version.list_all core_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_core_definition_versions",
        op_kwargs={
            "CoreDefinitionId": core_definition_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
