"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    amzn_client_token: str = None,
    initial_version: Dict = None,
    name: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a core definition. You may provide the initial version of the core definition now or use ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        initial_version(Dict, optional): Information about the initial version of the core definition. Defaults to None.
        name(str, optional): The name of the core definition. Defaults to None.
        tags(Dict, optional): Tag(s) to add to the new resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.core_definition.init.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.core_definition.init.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_core_definition",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "InitialVersion": initial_version,
            "Name": name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, core_definition_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a core definition.

    Args:
        core_definition_id(str): The ID of the core definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.core_definition.init.delete(
                ctx, core_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.core_definition.init.delete core_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="delete_core_definition",
        op_kwargs={"CoreDefinitionId": core_definition_id},
    )


async def get(hub, ctx, core_definition_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a core definition version.

    Args:
        core_definition_id(str): The ID of the core definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.core_definition.init.get(
                ctx, core_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.core_definition.init.get core_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_core_definition",
        op_kwargs={"CoreDefinitionId": core_definition_id},
    )


async def list_all(hub, ctx, max_results: str = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of core definitions.

    Args:
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.core_definition.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.core_definition.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_core_definitions",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, core_definition_id: str, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a core definition.

    Args:
        core_definition_id(str): The ID of the core definition.
        name(str, optional): The name of the definition. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.core_definition.init.update(
                ctx, core_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.core_definition.init.update core_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="update_core_definition",
        op_kwargs={"CoreDefinitionId": core_definition_id, "Name": name},
    )
