"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    connector_definition_id: str,
    amzn_client_token: str = None,
    connectors: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a version of a connector definition which has already been defined.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        connector_definition_id(str): The ID of the connector definition.
        connectors(List, optional): A list of references to connectors in this version, with their corresponding configuration settings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.connector_definition.version.create(
                ctx, connector_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.connector_definition.version.create connector_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="create_connector_definition_version",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "ConnectorDefinitionId": connector_definition_id,
            "Connectors": connectors,
        },
    )


async def get(
    hub,
    ctx,
    connector_definition_id: str,
    connector_definition_version_id: str,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a connector definition version, including the connectors that the version contains. Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud services.

    Args:
        connector_definition_id(str): The ID of the connector definition.
        connector_definition_version_id(str): The ID of the connector definition version. This value maps to the ''Version'' property of the corresponding ''VersionInformation'' object, which is returned by ''ListConnectorDefinitionVersions'' requests. If the version is the last one that was associated with a connector definition, the value also maps to the ''LatestVersion'' property of the corresponding ''DefinitionInformation'' object.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.connector_definition.version.get(
                ctx, connector_definition_id=value, connector_definition_version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.connector_definition.version.get connector_definition_id=value, connector_definition_version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_connector_definition_version",
        op_kwargs={
            "ConnectorDefinitionId": connector_definition_id,
            "ConnectorDefinitionVersionId": connector_definition_version_id,
            "NextToken": next_token,
        },
    )


async def list_all(
    hub,
    ctx,
    connector_definition_id: str,
    max_results: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the versions of a connector definition, which are containers for connectors. Connectors run on the Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other cloud services.

    Args:
        connector_definition_id(str): The ID of the connector definition.
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.connector_definition.version.list_all(
                ctx, connector_definition_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.connector_definition.version.list_all connector_definition_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_connector_definition_versions",
        op_kwargs={
            "ConnectorDefinitionId": connector_definition_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
