"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, bulk_deployment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the status of a bulk deployment.

    Args:
        bulk_deployment_id(str): The ID of the bulk deployment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.bulk_deployment.status.get(
                ctx, bulk_deployment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.bulk_deployment.status.get bulk_deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="get_bulk_deployment_status",
        op_kwargs={"BulkDeploymentId": bulk_deployment_id},
    )
