"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, max_results: str = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of bulk deployments.

    Args:
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.bulk_deployment.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.bulk_deployment.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_bulk_deployments",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def start(
    hub,
    ctx,
    execution_role_arn: str,
    input_file_uri: str,
    amzn_client_token: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These requests are idempotent with respect to the token and the request parameters.

    Args:
        amzn_client_token(str, optional): A client token used to correlate requests and responses. Defaults to None.
        execution_role_arn(str): The ARN of the execution role to associate with the bulk deployment operation. This IAM role must allow the ''greengrass:CreateDeployment'' action for all group versions that are listed in the input file. This IAM role must have access to the S3 bucket containing the input file.
        input_file_uri(str): The URI of the input file contained in the S3 bucket. The execution role must have ''getObject'' permissions on this bucket to access the input file. The input file is a JSON-serialized, line delimited file with UTF-8 encoding that provides a list of group and version IDs and the deployment type. This file must be less than 100 MB. Currently, AWS IoT Greengrass supports only ''NewDeployment'' deployment types.
        tags(Dict, optional): Tag(s) to add to the new resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.bulk_deployment.init.start(
                ctx, execution_role_arn=value, input_file_uri=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.bulk_deployment.init.start execution_role_arn=value, input_file_uri=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="start_bulk_deployment",
        op_kwargs={
            "AmznClientToken": amzn_client_token,
            "ExecutionRoleArn": execution_role_arn,
            "InputFileUri": input_file_uri,
            "tags": tags,
        },
    )


async def stop(hub, ctx, bulk_deployment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This action doesn't rollback completed deployments or cancel pending deployments.

    Args:
        bulk_deployment_id(str): The ID of the bulk deployment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.bulk_deployment.init.stop(
                ctx, bulk_deployment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.bulk_deployment.init.stop bulk_deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="stop_bulk_deployment",
        op_kwargs={"BulkDeploymentId": bulk_deployment_id},
    )
