"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, bulk_deployment_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current deployment status.

    Args:
        bulk_deployment_id(str): The ID of the bulk deployment.
        max_results(str, optional): The maximum number of results to be returned per request. Defaults to None.
        next_token(str, optional): The token for the next set of results, or ''null'' if there are no additional results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.greengrass.bulk_deployment.detailed_report.list_all(
                ctx, bulk_deployment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.greengrass.bulk_deployment.detailed_report.list_all bulk_deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="greengrass",
        operation="list_bulk_deployment_detailed_reports",
        op_kwargs={
            "BulkDeploymentId": bulk_deployment_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
