"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "property"


async def get_all(hub, ctx, name: str, run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the workflow run properties which were set during the run.

    Args:
        name(str): Name of the workflow which was run.
        run_id(str): The ID of the workflow run whose run properties should be returned.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.run.property_.get_all(
                ctx, name=value, run_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.run.property.get_all name=value, run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_workflow_run_properties",
        op_kwargs={"Name": name, "RunId": run_id},
    )


async def put_multiple(hub, ctx, name: str, run_id: str, run_properties: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Puts the specified workflow run properties for the given workflow run. If a property already exists for the specified run, then it overrides the value otherwise adds the property to existing properties.

    Args:
        name(str): Name of the workflow which was run.
        run_id(str): The ID of the workflow run for which the run properties should be updated.
        run_properties(Dict): The properties to put for the specified run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.run.property_.put_multiple(
                ctx, name=value, run_id=value, run_properties=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.run.property.put_multiple name=value, run_id=value, run_properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="put_workflow_run_properties",
        op_kwargs={"Name": name, "RunId": run_id, "RunProperties": run_properties},
    )
