"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, name: str, run_id: str, include_graph: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the metadata for a given workflow run.

    Args:
        name(str): Name of the workflow being run.
        run_id(str): The ID of the workflow run.
        include_graph(bool, optional): Specifies whether to include the workflow graph in response or not. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.run.init.get(ctx, name=value, run_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.run.init.get name=value, run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_workflow_run",
        op_kwargs={"Name": name, "RunId": run_id, "IncludeGraph": include_graph},
    )


async def get_all(
    hub,
    ctx,
    name: str,
    include_graph: bool = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves metadata for all runs of a given workflow.

    Args:
        name(str): Name of the workflow whose metadata of runs should be returned.
        include_graph(bool, optional): Specifies whether to include the workflow graph in response or not. Defaults to None.
        next_token(str, optional): The maximum size of the response. Defaults to None.
        max_results(int, optional): The maximum number of workflow runs to be included in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.run.init.get_all(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.run.init.get_all name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_workflow_runs",
        op_kwargs={
            "Name": name,
            "IncludeGraph": include_graph,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def resume(hub, ctx, name: str, run_id: str, node_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Restarts selected nodes of a previous partially completed workflow run and resumes the workflow run. The selected nodes and all nodes that are downstream from the selected nodes are run.

    Args:
        name(str): The name of the workflow to resume.
        run_id(str): The ID of the workflow run to resume.
        node_ids(List): A list of the node IDs for the nodes you want to restart. The nodes that are to be restarted must have a run attempt in the original run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.run.init.resume(
                ctx, name=value, run_id=value, node_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.run.init.resume name=value, run_id=value, node_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="resume_workflow_run",
        op_kwargs={"Name": name, "RunId": run_id, "NodeIds": node_ids},
    )


async def start(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts a new run of the specified workflow.

    Args:
        name(str): The name of the workflow to start.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.run.init.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.run.init.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="start_workflow_run",
        op_kwargs={"Name": name},
    )


async def stop(hub, ctx, name: str, run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the execution of the specified workflow run.

    Args:
        name(str): The name of the workflow to stop.
        run_id(str): The ID of the workflow run to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.run.init.stop(ctx, name=value, run_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.run.init.stop name=value, run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="stop_workflow_run",
        op_kwargs={"Name": name, "RunId": run_id},
    )
