"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    default_run_properties: Dict = None,
    tags: Dict = None,
    max_concurrent_runs: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new workflow.

    Args:
        name(str): The name to be assigned to the workflow. It should be unique within your account.
        description(str, optional): A description of the workflow. Defaults to None.
        default_run_properties(Dict, optional): A collection of properties to be used as part of each execution of the workflow. Defaults to None.
        tags(Dict, optional): The tags to be used with this workflow. Defaults to None.
        max_concurrent_runs(int, optional): You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_workflow",
        op_kwargs={
            "Name": name,
            "Description": description,
            "DefaultRunProperties": default_run_properties,
            "Tags": tags,
            "MaxConcurrentRuns": max_concurrent_runs,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a workflow.

    Args:
        name(str): Name of the workflow to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="glue", operation="delete_workflow", op_kwargs={"Name": name}
    )


async def get(hub, ctx, name: str, include_graph: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves resource metadata for a workflow.

    Args:
        name(str): The name of the workflow to retrieve.
        include_graph(bool, optional): Specifies whether to include a graph when returning the workflow resource metadata. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_workflow",
        op_kwargs={"Name": name, "IncludeGraph": include_graph},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists names of workflows created in the account.

    Args:
        next_token(str, optional): A continuation token, if this is a continuation request. Defaults to None.
        max_results(int, optional): The maximum size of a list to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="list_workflows",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    name: str,
    description: str = None,
    default_run_properties: Dict = None,
    max_concurrent_runs: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing workflow.

    Args:
        name(str): Name of the workflow to be updated.
        description(str, optional): The description of the workflow. Defaults to None.
        default_run_properties(Dict, optional): A collection of properties to be used as part of each execution of the workflow. Defaults to None.
        max_concurrent_runs(int, optional): You can use this parameter to prevent unwanted multiple updates to data, to control costs, or in some cases, to prevent exceeding the maximum number of concurrent runs of any of the component jobs. If you leave this parameter blank, there is no limit to the number of concurrent workflow runs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.workflow.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.workflow.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_workflow",
        op_kwargs={
            "Name": name,
            "Description": description,
            "DefaultRunProperties": default_run_properties,
            "MaxConcurrentRuns": max_concurrent_runs,
        },
    )
