"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, database_name: str, function_input: Dict, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new function definition in the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which to create the function. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database in which to create the function.
        function_input(Dict): A FunctionInput object that defines the function to create in the Data Catalog.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.user_defined_function.create(
                ctx, database_name=value, function_input=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.user_defined_function.create database_name=value, function_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_user_defined_function",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "FunctionInput": function_input,
        },
    )


async def delete(
    hub, ctx, database_name: str, function_name: str, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing function definition from the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the function to be deleted is located. If none is supplied, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the function is located.
        function_name(str): The name of the function definition to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.user_defined_function.delete(
                ctx, database_name=value, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.user_defined_function.delete database_name=value, function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_user_defined_function",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "FunctionName": function_name,
        },
    )


async def get(
    hub, ctx, database_name: str, function_name: str, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a specified function definition from the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the function to be retrieved is located. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the function is located.
        function_name(str): The name of the function.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.user_defined_function.get(
                ctx, database_name=value, function_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.user_defined_function.get database_name=value, function_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_user_defined_function",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "FunctionName": function_name,
        },
    )


async def get_all(
    hub,
    ctx,
    pattern: str,
    catalog_id: str = None,
    database_name: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves multiple function definitions from the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the functions to be retrieved are located. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str, optional): The name of the catalog database where the functions are located. If none is provided, functions from all the databases across the catalog will be returned. Defaults to None.
        pattern(str): An optional function-name pattern string that filters the function definitions returned.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.
        max_results(int, optional): The maximum number of functions to return in one response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.user_defined_function.get_all(ctx, pattern=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.user_defined_function.get_all pattern=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_user_defined_functions",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "Pattern": pattern,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    database_name: str,
    function_name: str,
    function_input: Dict,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing function definition in the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the function to be updated is located. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the function to be updated is located.
        function_name(str): The name of the function.
        function_input(Dict): A FunctionInput object that redefines the function in the Data Catalog.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.user_defined_function.update(
                ctx, database_name=value, function_name=value, function_input=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.user_defined_function.update database_name=value, function_name=value, function_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_user_defined_function",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "FunctionName": function_name,
            "FunctionInput": function_input,
        },
    )
