"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, database_name: str, table_name: str, entries: List, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates one or more partitions in a batch operation.

    Args:
        catalog_id(str, optional): The ID of the catalog in which the partition is to be updated. Currently, this should be the Amazon Web Services account ID. Defaults to None.
        database_name(str): The name of the metadata database in which the partition is to be updated.
        table_name(str): The name of the metadata table in which the partition is to be updated.
        entries(List): A list of up to 100 BatchUpdatePartitionRequestEntry objects to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.update_partition.batch(
                ctx, database_name=value, table_name=value, entries=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.update_partition.batch database_name=value, table_name=value, entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_update_partition",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "Entries": entries,
        },
    )
