"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    type_: str,
    actions: List,
    workflow_name: str = None,
    schedule: str = None,
    predicate: Dict = None,
    description: str = None,
    start_on_creation: bool = None,
    tags: Dict = None,
    event_batching_condition: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new trigger.

    Args:
        name(str): The name of the trigger.
        workflow_name(str, optional): The name of the workflow associated with the trigger. Defaults to None.
        type_(str): The type of the new trigger.
        schedule(str, optional): A cron expression used to specify the schedule (see Time-Based Schedules for Jobs and Crawlers. For example, to run something every day at 12:15 UTC, you would specify: cron(15 12 * * ? *). This field is required when the trigger type is SCHEDULED. Defaults to None.
        predicate(Dict, optional): A predicate to specify when the new trigger should fire. This field is required when the trigger type is CONDITIONAL. Defaults to None.
        actions(List): The actions initiated by this trigger when it fires.
        description(str, optional): A description of the new trigger. Defaults to None.
        start_on_creation(bool, optional): Set to true to start SCHEDULED and CONDITIONAL triggers when created. True is not supported for ON_DEMAND triggers. Defaults to None.
        tags(Dict, optional): The tags to use with this trigger. You may use tags to limit access to the trigger. For more information about tags in Glue, see Amazon Web Services Tags in Glue in the developer guide. . Defaults to None.
        event_batching_condition(Dict, optional): Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.trigger.create(ctx, name=value, type_=value, actions=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.trigger.create name=value, type_=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_trigger",
        op_kwargs={
            "Name": name,
            "WorkflowName": workflow_name,
            "Type": type_,
            "Schedule": schedule,
            "Predicate": predicate,
            "Actions": actions,
            "Description": description,
            "StartOnCreation": start_on_creation,
            "Tags": tags,
            "EventBatchingCondition": event_batching_condition,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified trigger. If the trigger is not found, no exception is thrown.

    Args:
        name(str): The name of the trigger to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.trigger.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.trigger.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="glue", operation="delete_trigger", op_kwargs={"Name": name}
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the definition of a trigger.

    Args:
        name(str): The name of the trigger to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.trigger.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.trigger.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="glue", operation="get_trigger", op_kwargs={"Name": name}
    )


async def get_all(
    hub,
    ctx,
    next_token: str = None,
    dependent_job_name: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all the triggers associated with a job.

    Args:
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.
        dependent_job_name(str, optional): The name of the job to retrieve triggers for. The trigger that can start this job is returned, and if there is no such trigger, all triggers are returned. Defaults to None.
        max_results(int, optional): The maximum size of the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.trigger.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.trigger.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_triggers",
        op_kwargs={
            "NextToken": next_token,
            "DependentJobName": dependent_job_name,
            "MaxResults": max_results,
        },
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    dependent_job_name: str = None,
    max_results: int = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the names of all trigger resources in this Amazon Web Services account, or the resources with the specified tag. This operation allows you to see which resources are available in your account, and their names. This operation takes the optional Tags field, which you can use as a filter on the response so that tagged resources can be retrieved as a group. If you choose to use tags filtering, only resources with the tag are retrieved.

    Args:
        next_token(str, optional): A continuation token, if this is a continuation request. Defaults to None.
        dependent_job_name(str, optional):  The name of the job for which to retrieve triggers. The trigger that can start this job is returned. If there is no such trigger, all triggers are returned. Defaults to None.
        max_results(int, optional): The maximum size of a list to return. Defaults to None.
        tags(Dict, optional): Specifies to return only these tagged resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.trigger.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.trigger.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="list_triggers",
        op_kwargs={
            "NextToken": next_token,
            "DependentJobName": dependent_job_name,
            "MaxResults": max_results,
            "Tags": tags,
        },
    )


async def start(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts an existing trigger. See Triggering Jobs for information about how different types of trigger are started.

    Args:
        name(str): The name of the trigger to start.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.trigger.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.trigger.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="glue", operation="start_trigger", op_kwargs={"Name": name}
    )


async def stop(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a specified trigger.

    Args:
        name(str): The name of the trigger to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.trigger.stop(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.trigger.stop name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="glue", operation="stop_trigger", op_kwargs={"Name": name}
    )


async def update(hub, ctx, name: str, trigger_update: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates a trigger definition.

    Args:
        name(str): The name of the trigger to update.
        trigger_update(Dict): The new values with which to update the trigger.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.trigger.update(ctx, name=value, trigger_update=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.trigger.update name=value, trigger_update=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_trigger",
        op_kwargs={"Name": name, "TriggerUpdate": trigger_update},
    )
