"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    version_id: str,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified version of a table.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.
        table_name(str): The name of the table. For Hive compatibility, this name is entirely lowercase.
        version_id(str): The ID of the table version to be deleted. A VersionID is a string representation of an integer. Each version is incremented by 1.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.version.delete(
                ctx, database_name=value, table_name=value, version_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.version.delete database_name=value, table_name=value, version_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_table_version",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "VersionId": version_id,
        },
    )


async def get(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    catalog_id: str = None,
    version_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a specified version of a table.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.
        table_name(str): The name of the table. For Hive compatibility, this name is entirely lowercase.
        version_id(str, optional): The ID value of the table version to be retrieved. A VersionID is a string representation of an integer. Each version is incremented by 1. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.version.get(
                ctx, database_name=value, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.version.get database_name=value, table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_table_version",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "VersionId": version_id,
        },
    )


async def get_all(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    catalog_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of strings that identify available versions of a specified table.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.
        table_name(str): The name of the table. For Hive compatibility, this name is entirely lowercase.
        next_token(str, optional): A continuation token, if this is not the first call. Defaults to None.
        max_results(int, optional): The maximum number of table versions to return in one response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.version.get_all(
                ctx, database_name=value, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.version.get_all database_name=value, table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_table_versions",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
