"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    database_name: str,
    table_input: Dict,
    catalog_id: str = None,
    partition_indexes: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new table definition in the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog in which to create the Table. If none is supplied, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The catalog database in which to create the new table. For Hive compatibility, this name is entirely lowercase.
        table_input(Dict): The TableInput object that defines the metadata table to create in the catalog.
        partition_indexes(List, optional): A list of partition indexes, PartitionIndex structures, to create in the table. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.init.create(
                ctx, database_name=value, table_input=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.init.create database_name=value, table_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_table",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableInput": table_input,
            "PartitionIndexes": partition_indexes,
        },
    )


async def delete(
    hub, ctx, database_name: str, name: str, catalog_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a table definition from the Data Catalog.  After completing this operation, you no longer have access to the table versions and partitions that belong to the deleted table. Glue deletes these "orphaned" resources asynchronously in a timely manner, at the discretion of the service. To ensure the immediate deletion of all related resources, before calling DeleteTable, use DeleteTableVersion or BatchDeleteTableVersion, and DeletePartition or BatchDeletePartition, to delete any resources that belong to the table.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database in which the table resides. For Hive compatibility, this name is entirely lowercase.
        name(str): The name of the table to be deleted. For Hive compatibility, this name is entirely lowercase.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.init.delete(ctx, database_name=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.init.delete database_name=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_table",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "Name": name,
        },
    )


async def get(hub, ctx, database_name: str, name: str, catalog_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the Table definition in a Data Catalog for a specified table.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the database in the catalog in which the table resides. For Hive compatibility, this name is entirely lowercase.
        name(str): The name of the table for which to retrieve the definition. For Hive compatibility, this name is entirely lowercase.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.init.get(ctx, database_name=value, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.init.get database_name=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_table",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "Name": name,
        },
    )


async def get_all(
    hub,
    ctx,
    database_name: str,
    catalog_id: str = None,
    expression: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the definitions of some or all of the tables in a given Database.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the tables reside. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The database in the catalog whose tables to list. For Hive compatibility, this name is entirely lowercase.
        expression(str, optional): A regular expression pattern. If present, only those tables whose names match the pattern are returned. Defaults to None.
        next_token(str, optional): A continuation token, included if this is a continuation call. Defaults to None.
        max_results(int, optional): The maximum number of tables to return in a single response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.init.get_all(ctx, database_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.init.get_all database_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_tables",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "Expression": expression,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def search(
    hub,
    ctx,
    catalog_id: str = None,
    next_token: str = None,
    filters: List = None,
    search_text: str = None,
    sort_criteria: List = None,
    max_results: int = None,
    resource_share_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Searches a set of tables based on properties in the table metadata as well as on the parent database. You can search against text or filter conditions.  You can only get tables that you have access to based on the security policies defined in Lake Formation. You need at least a read-only access to the table for it to be returned. If you do not have access to all the columns in the table, these columns will not be searched against when returning the list of tables back to you. If you have access to the columns but not the data in the columns, those columns and the associated metadata for those columns will be included in the search.

    Args:
        catalog_id(str, optional): A unique identifier, consisting of  account_id . Defaults to None.
        next_token(str, optional): A continuation token, included if this is a continuation call. Defaults to None.
        filters(List, optional): A list of key-value pairs, and a comparator used to filter the search results. Returns all entities matching the predicate. The Comparator member of the PropertyPredicate struct is used only for time fields, and can be omitted for other field types. Also, when comparing string values, such as when Key=Name, a fuzzy match algorithm is used. The Key field (for example, the value of the Name field) is split on certain punctuation characters, for example, -, :, #, etc. into tokens. Then each token is exact-match compared with the Value member of PropertyPredicate. For example, if Key=Name and Value=link, tables named customer-link and xx-link-yy are returned, but xxlinkyy is not returned. Defaults to None.
        search_text(str, optional): A string used for a text search. Specifying a value in quotes filters based on an exact match to the value. Defaults to None.
        sort_criteria(List, optional): A list of criteria for sorting the results by a field name, in an ascending or descending order. Defaults to None.
        max_results(int, optional): The maximum number of tables to return in a single response. Defaults to None.
        resource_share_type(str, optional): Allows you to specify that you want to search the tables shared with your account. The allowable values are FOREIGN or ALL.    If set to FOREIGN, will search the tables shared with your account.    If set to ALL, will search the tables shared with your account, as well as the tables in yor local account.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="search_tables",
        op_kwargs={
            "CatalogId": catalog_id,
            "NextToken": next_token,
            "Filters": filters,
            "SearchText": search_text,
            "SortCriteria": sort_criteria,
            "MaxResults": max_results,
            "ResourceShareType": resource_share_type,
        },
    )


async def update(
    hub,
    ctx,
    database_name: str,
    table_input: Dict,
    catalog_id: str = None,
    skip_archive: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a metadata table in the Data Catalog.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the table resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database in which the table resides. For Hive compatibility, this name is entirely lowercase.
        table_input(Dict): An updated TableInput object to define the metadata table in the catalog.
        skip_archive(bool, optional): By default, UpdateTable always creates an archived version of the table before updating it. However, if skipArchive is set to true, UpdateTable does not create the archived version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.table.init.update(
                ctx, database_name=value, table_input=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.table.init.update database_name=value, table_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_table",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableInput": table_input,
            "SkipArchive": skip_archive,
        },
    )
