"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, job_name: str, job_run_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Stops one or more job runs for a specified job definition.

    Args:
        job_name(str): The name of the job definition for which to stop job runs.
        job_run_ids(List): A list of the JobRunIds that should be stopped for that job definition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.stop_job_run.batch(ctx, job_name=value, job_run_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.stop_job_run.batch job_name=value, job_run_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="batch_stop_job_run",
        op_kwargs={"JobName": job_name, "JobRunIds": job_run_ids},
    )
