"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, encryption_configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new security configuration. A security configuration is a set of security properties that can be used by Glue. You can use a security configuration to encrypt data at rest. For information about using security configurations in Glue, see Encrypting Data Written by Crawlers, Jobs, and Development Endpoints.

    Args:
        name(str): The name for the new security configuration.
        encryption_configuration(Dict): The encryption configuration for the new security configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.security_configuration.create(
                ctx, name=value, encryption_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.security_configuration.create name=value, encryption_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_security_configuration",
        op_kwargs={"Name": name, "EncryptionConfiguration": encryption_configuration},
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified security configuration.

    Args:
        name(str): The name of the security configuration to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.security_configuration.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.security_configuration.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_security_configuration",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a specified security configuration.

    Args:
        name(str): The name of the security configuration to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.security_configuration.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.security_configuration.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_security_configuration",
        op_kwargs={"Name": name},
    )


async def get_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of all security configurations.

    Args:
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.security_configuration.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.security_configuration.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_security_configurations",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
