"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, dag_nodes: List = None, dag_edges: List = None, language: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Transforms a directed acyclic graph (DAG) into code.

    Args:
        dag_nodes(List, optional): A list of the nodes in the DAG. Defaults to None.
        dag_edges(List, optional): A list of the edges in the DAG. Defaults to None.
        language(str, optional): The programming language of the resulting code from the DAG. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.script.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.script.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_script",
        op_kwargs={"DagNodes": dag_nodes, "DagEdges": dag_edges, "Language": language},
    )
