"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, registry_id: Dict = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of schemas with minimal details. Schemas in Deleting status will not be included in the results. Empty results will be returned if there are no schemas available. When the RegistryId is not provided, all the schemas across registries will be part of the API response.

    Args:
        registry_id(Dict, optional): A wrapper structure that may contain the registry name and Amazon Resource Name (ARN). Defaults to None.
        max_results(int, optional): Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schemas.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schemas.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="list_schemas",
        op_kwargs={
            "RegistryId": registry_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
