"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def check(hub, ctx, data_format: str, schema_definition: str) -> Dict:
    r"""
    **Autogenerated function**

    Validates the supplied schema. This call has no side effects, it simply validates using the supplied schema using DataFormat as the format. Since it does not take a schema set name, no compatibility checks are performed.

    Args:
        data_format(str): The data format of the schema definition. Currently AVRO and JSON are supported.
        schema_definition(str): The definition of the schema that has to be validated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.validity.check(
                ctx, data_format=value, schema_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.validity.check data_format=value, schema_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="check_schema_version_validity",
        op_kwargs={"DataFormat": data_format, "SchemaDefinition": schema_definition},
    )
