"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put(
    hub,
    ctx,
    metadata_key_value: Dict,
    schema_id: Dict = None,
    schema_version_number: Dict = None,
    schema_version_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Puts the metadata key value pair for a specified schema version ID. A maximum of 10 key value pairs will be allowed per schema version. They can be added over one or more calls.

    Args:
        schema_id(Dict, optional): The unique ID for the schema. Defaults to None.
        schema_version_number(Dict, optional): The version number of the schema. Defaults to None.
        schema_version_id(str, optional): The unique version ID of the schema version. Defaults to None.
        metadata_key_value(Dict): The metadata key's corresponding value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.metadata.put(ctx, metadata_key_value=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.metadata.put metadata_key_value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="put_schema_version_metadata",
        op_kwargs={
            "SchemaId": schema_id,
            "SchemaVersionNumber": schema_version_number,
            "SchemaVersionId": schema_version_id,
            "MetadataKeyValue": metadata_key_value,
        },
    )


async def query(
    hub,
    ctx,
    schema_id: Dict = None,
    schema_version_number: Dict = None,
    schema_version_id: str = None,
    metadata_list: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Queries for the schema version metadata information.

    Args:
        schema_id(Dict, optional): A wrapper structure that may contain the schema name and Amazon Resource Name (ARN). Defaults to None.
        schema_version_number(Dict, optional): The version number of the schema. Defaults to None.
        schema_version_id(str, optional): The unique version ID of the schema version. Defaults to None.
        metadata_list(List, optional): Search key-value pairs for metadata, if they are not provided all the metadata information will be fetched. Defaults to None.
        max_results(int, optional): Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.metadata.query(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.metadata.query
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="query_schema_version_metadata",
        op_kwargs={
            "SchemaId": schema_id,
            "SchemaVersionNumber": schema_version_number,
            "SchemaVersionId": schema_version_id,
            "MetadataList": metadata_list,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def remove(
    hub,
    ctx,
    metadata_key_value: Dict,
    schema_id: Dict = None,
    schema_version_number: Dict = None,
    schema_version_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes a key value pair from the schema version metadata for the specified schema version ID.

    Args:
        schema_id(Dict, optional): A wrapper structure that may contain the schema name and Amazon Resource Name (ARN). Defaults to None.
        schema_version_number(Dict, optional): The version number of the schema. Defaults to None.
        schema_version_id(str, optional): The unique version ID of the schema version. Defaults to None.
        metadata_key_value(Dict): The value of the metadata key.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.metadata.remove(
                ctx, metadata_key_value=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.metadata.remove metadata_key_value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="remove_schema_version_metadata",
        op_kwargs={
            "SchemaId": schema_id,
            "SchemaVersionNumber": schema_version_number,
            "SchemaVersionId": schema_version_id,
            "MetadataKeyValue": metadata_key_value,
        },
    )
