"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete_multiple(hub, ctx, schema_id: Dict, versions: str) -> Dict:
    r"""
    **Autogenerated function**

    Remove versions from the specified schema. A version number or range may be supplied. If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned. Calling the GetSchemaVersions API after this call will list the status of the deleted versions. When the range of version numbers contain check pointed version, the API will return a 409 conflict and will not proceed with the deletion. You have to remove the checkpoint first using the DeleteSchemaCheckpoint API before using this API. You cannot use the DeleteSchemaVersions API to delete the first schema version in the schema set. The first schema version can only be deleted by the DeleteSchema API. This operation will also delete the attached SchemaVersionMetadata under the schema versions. Hard deletes will be enforced on the database. If the compatibility mode forbids deleting of a version that is necessary, such as BACKWARDS_FULL, an error is returned.

    Args:
        schema_id(Dict): This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
        versions(str): A version range may be supplied which may be of the format:   a single version number, 5   a range, 5-8 : deletes versions 5, 6, 7, 8  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.init.delete_multiple(
                ctx, schema_id=value, versions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.init.delete_multiple schema_id=value, versions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_schema_versions",
        op_kwargs={"SchemaId": schema_id, "Versions": versions},
    )


async def get(
    hub,
    ctx,
    schema_id: Dict = None,
    schema_version_id: str = None,
    schema_version_number: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get the specified schema by its unique ID assigned when a version of the schema is created or registered. Schema versions in Deleted status will not be included in the results.

    Args:
        schema_id(Dict, optional): This is a wrapper structure to contain schema identity fields. The structure contains:   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either SchemaArn or SchemaName and RegistryName has to be provided.   SchemaId$SchemaName: The name of the schema. Either SchemaArn or SchemaName and RegistryName has to be provided.  . Defaults to None.
        schema_version_id(str, optional): The SchemaVersionId of the schema version. This field is required for fetching by schema ID. Either this or the SchemaId wrapper has to be provided. Defaults to None.
        schema_version_number(Dict, optional): The version number of the schema. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_schema_version",
        op_kwargs={
            "SchemaId": schema_id,
            "SchemaVersionId": schema_version_id,
            "SchemaVersionNumber": schema_version_number,
        },
    )


async def list_all(
    hub, ctx, schema_id: Dict, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of schema versions that you have created, with minimal information. Schema versions in Deleted status will not be included in the results. Empty results will be returned if there are no schema versions available.

    Args:
        schema_id(Dict): This is a wrapper structure to contain schema identity fields. The structure contains:   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either SchemaArn or SchemaName and RegistryName has to be provided.   SchemaId$SchemaName: The name of the schema. Either SchemaArn or SchemaName and RegistryName has to be provided.  .
        max_results(int, optional): Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.init.list_all(ctx, schema_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.init.list_all schema_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="list_schema_versions",
        op_kwargs={
            "SchemaId": schema_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def register(hub, ctx, schema_id: Dict, schema_definition: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new version to the existing schema. Returns an error if new version of schema does not meet the compatibility requirements of the schema set. This API will not create a new schema set and will return a 404 error if the schema set is not already present in the Schema Registry. If this is the first schema definition to be registered in the Schema Registry, this API will store the schema version and return immediately. Otherwise, this call has the potential to run longer than other operations due to compatibility modes. You can call the GetSchemaVersion API with the SchemaVersionId to check compatibility modes. If the same schema definition is already stored in Schema Registry as a version, the schema ID of the existing schema is returned to the caller.

    Args:
        schema_id(Dict): This is a wrapper structure to contain schema identity fields. The structure contains:   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either SchemaArn or SchemaName and RegistryName has to be provided.   SchemaId$SchemaName: The name of the schema. Either SchemaArn or SchemaName and RegistryName has to be provided.  .
        schema_definition(str): The schema definition using the DataFormat setting for the SchemaName.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.init.register(
                ctx, schema_id=value, schema_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.init.register schema_id=value, schema_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="register_schema_version",
        op_kwargs={"SchemaId": schema_id, "SchemaDefinition": schema_definition},
    )
