"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    schema_id: Dict,
    first_schema_version_number: Dict,
    second_schema_version_number: Dict,
    schema_diff_type: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Fetches the schema version difference in the specified difference type between two stored schema versions in the Schema Registry. This API allows you to compare two schema versions between two schema definitions under the same schema.

    Args:
        schema_id(Dict): This is a wrapper structure to contain schema identity fields. The structure contains:   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of SchemaArn or SchemaName has to be provided.   SchemaId$SchemaName: The name of the schema. One of SchemaArn or SchemaName has to be provided.  .
        first_schema_version_number(Dict): The first of the two schema versions to be compared.
        second_schema_version_number(Dict): The second of the two schema versions to be compared.
        schema_diff_type(str): Refers to SYNTAX_DIFF, which is the currently supported diff type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.version.diff.get(
                ctx,
                schema_id=value,
                first_schema_version_number=value,
                second_schema_version_number=value,
                schema_diff_type=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.version.diff.get schema_id=value, first_schema_version_number=value, second_schema_version_number=value, schema_diff_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_schema_versions_diff",
        op_kwargs={
            "SchemaId": schema_id,
            "FirstSchemaVersionNumber": first_schema_version_number,
            "SecondSchemaVersionNumber": second_schema_version_number,
            "SchemaDiffType": schema_diff_type,
        },
    )
