"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    schema_name: str,
    data_format: str,
    registry_id: Dict = None,
    compatibility: str = None,
    description: str = None,
    tags: Dict = None,
    schema_definition: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new schema set and registers the schema definition. Returns an error if the schema set already exists without actually registering the version. When the schema set is created, a version checkpoint will be set to the first version. Compatibility mode "DISABLED" restricts any additional schema versions from being added after the first schema version. For all other compatibility modes, validation of compatibility settings will be applied only from the second version onwards when the RegisterSchemaVersion API is used. When this API is called without a RegistryId, this will create an entry for a "default-registry" in the registry database tables, if it is not already present.

    Args:
        registry_id(Dict, optional):  This is a wrapper shape to contain the registry identity fields. If this is not provided, the default registry will be used. The ARN format for the same will be: arn:aws:glue:us-east-2:<customer id>:registry/default-registry:random-5-letter-id. Defaults to None.
        schema_name(str): Name of the schema to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore, dollar sign, or hash mark. No whitespace.
        data_format(str): The data format of the schema definition. Currently AVRO and JSON are supported.
        compatibility(str, optional): The compatibility mode of the schema. The possible values are:    NONE: No compatibility mode applies. You can use this choice in development scenarios or if you do not know the compatibility mode that you want to apply to schemas. Any new version added will be accepted without undergoing a compatibility check.    DISABLED: This compatibility choice prevents versioning for a particular schema. You can use this choice to prevent future versioning of a schema.    BACKWARD: This compatibility choice is recommended as it allows data receivers to read both the current and one previous schema version. This means that for instance, a new schema version cannot drop data fields or change the type of these fields, so they can't be read by readers using the previous version.    BACKWARD_ALL: This compatibility choice allows data receivers to read both the current and all previous schema versions. You can use this choice when you need to delete fields or add optional fields, and check compatibility against all previous schema versions.     FORWARD: This compatibility choice allows data receivers to read both the current and one next schema version, but not necessarily later versions. You can use this choice when you need to add fields or delete optional fields, but only check compatibility against the last schema version.    FORWARD_ALL: This compatibility choice allows data receivers to read written by producers of any new registered schema. You can use this choice when you need to add fields or delete optional fields, and check compatibility against all previous schema versions.    FULL: This compatibility choice allows data receivers to read data written by producers using the previous or next version of the schema, but not necessarily earlier or later versions. You can use this choice when you need to add or remove optional fields, but only check compatibility against the last schema version.    FULL_ALL: This compatibility choice allows data receivers to read data written by producers using all previous schema versions. You can use this choice when you need to add or remove optional fields, and check compatibility against all previous schema versions.  . Defaults to None.
        description(str, optional): An optional description of the schema. If description is not provided, there will not be any automatic default value for this. Defaults to None.
        tags(Dict, optional): Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or API. If specified, follows the Amazon Web Services tags-on-create pattern. Defaults to None.
        schema_definition(str, optional): The schema definition using the DataFormat setting for SchemaName. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.init.create(
                ctx, schema_name=value, data_format=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.init.create schema_name=value, data_format=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_schema",
        op_kwargs={
            "RegistryId": registry_id,
            "SchemaName": schema_name,
            "DataFormat": data_format,
            "Compatibility": compatibility,
            "Description": description,
            "Tags": tags,
            "SchemaDefinition": schema_definition,
        },
    )


async def delete(hub, ctx, schema_id: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the entire schema set, including the schema set and all of its versions. To get the status of the delete operation, you can call GetSchema API after the asynchronous call. Deleting a registry will deactivate all online operations for the schema, such as the GetSchemaByDefinition, and RegisterSchemaVersion APIs.

    Args:
        schema_id(Dict): This is a wrapper structure that may contain the schema name and Amazon Resource Name (ARN).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.init.delete(ctx, schema_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.init.delete schema_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_schema",
        op_kwargs={"SchemaId": schema_id},
    )


async def get(hub, ctx, schema_id: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified schema in detail.

    Args:
        schema_id(Dict): This is a wrapper structure to contain schema identity fields. The structure contains:   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. Either SchemaArn or SchemaName and RegistryName has to be provided.   SchemaId$SchemaName: The name of the schema. Either SchemaArn or SchemaName and RegistryName has to be provided.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.init.get(ctx, schema_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.init.get schema_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_schema",
        op_kwargs={"SchemaId": schema_id},
    )


async def update(
    hub,
    ctx,
    schema_id: Dict,
    schema_version_number: Dict = None,
    compatibility: str = None,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the description, compatibility setting, or version checkpoint for a schema set. For updating the compatibility setting, the call will not validate compatibility for the entire set of schema versions with the new compatibility setting. If the value for Compatibility is provided, the VersionNumber (a checkpoint) is also required. The API will validate the checkpoint version number for consistency. If the value for the VersionNumber (checkpoint) is provided, Compatibility is optional and this can be used to set/reset a checkpoint for the schema. This update will happen only if the schema is in the AVAILABLE state.

    Args:
        schema_id(Dict): This is a wrapper structure to contain schema identity fields. The structure contains:   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of SchemaArn or SchemaName has to be provided.   SchemaId$SchemaName: The name of the schema. One of SchemaArn or SchemaName has to be provided.  .
        schema_version_number(Dict, optional): Version number required for check pointing. One of VersionNumber or Compatibility has to be provided. Defaults to None.
        compatibility(str, optional): The new compatibility setting for the schema. Defaults to None.
        description(str, optional): The new description for the schema. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.init.update(ctx, schema_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.init.update schema_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_schema",
        op_kwargs={
            "SchemaId": schema_id,
            "SchemaVersionNumber": schema_version_number,
            "Compatibility": compatibility,
            "Description": description,
        },
    )
