"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, schema_id: Dict, schema_definition: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a schema by the SchemaDefinition. The schema definition is sent to the Schema Registry, canonicalized, and hashed. If the hash is matched within the scope of the SchemaName or ARN (or the default registry, if none is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound error is returned. Schema versions in Deleted statuses will not be included in the results.

    Args:
        schema_id(Dict): This is a wrapper structure to contain schema identity fields. The structure contains:   SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema. One of SchemaArn or SchemaName has to be provided.   SchemaId$SchemaName: The name of the schema. One of SchemaArn or SchemaName has to be provided.  .
        schema_definition(str): The definition of the schema for which schema details are required.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.schema.by_definition.get(
                ctx, schema_id=value, schema_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.schema.by_definition.get schema_id=value, schema_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_schema_by_definition",
        op_kwargs={"SchemaId": schema_id, "SchemaDefinition": schema_definition},
    )
