"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags_to_add: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds tags to a resource. A tag is a label you can assign to an Amazon Web Services resource. In Glue, you can tag only certain resources. For information about what resources you can tag, see Amazon Web Services Tags in Glue.

    Args:
        resource_arn(str): The ARN of the Glue resource to which to add the tags. For more information about Glue resource ARNs, see the Glue ARN string pattern.
        tags_to_add(Dict): Tags to add to this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.resource.init.tag(
                ctx, resource_arn=value, tags_to_add=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.resource.init.tag resource_arn=value, tags_to_add=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagsToAdd": tags_to_add},
    )


async def untag(hub, ctx, resource_arn: str, tags_to_remove: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes tags from a resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource from which to remove the tags.
        tags_to_remove(List): Tags to remove from this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.resource.init.untag(
                ctx, resource_arn=value, tags_to_remove=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.resource.init.untag resource_arn=value, tags_to_remove=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagsToRemove": tags_to_remove},
    )
