"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, registry_name: str, description: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new registry which may be used to hold a collection of schemas.

    Args:
        registry_name(str): Name of the registry to be created of max length of 255, and may only contain letters, numbers, hyphen, underscore, dollar sign, or hash mark. No whitespace.
        description(str, optional): A description of the registry. If description is not provided, there will not be any default value for this. Defaults to None.
        tags(Dict, optional): Amazon Web Services tags that contain a key value pair and may be searched by console, command line, or API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.registry.create(ctx, registry_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.registry.create registry_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_registry",
        op_kwargs={
            "RegistryName": registry_name,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, registry_id: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Delete the entire registry including schema and all of its versions. To get the status of the delete operation, you can call the GetRegistry API after the asynchronous call. Deleting a registry will deactivate all online operations for the registry such as the UpdateRegistry, CreateSchema, UpdateSchema, and RegisterSchemaVersion APIs.

    Args:
        registry_id(Dict): This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.registry.delete(ctx, registry_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.registry.delete registry_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_registry",
        op_kwargs={"RegistryId": registry_id},
    )


async def get(hub, ctx, registry_id: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified registry in detail.

    Args:
        registry_id(Dict): This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.registry.get(ctx, registry_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.registry.get registry_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_registry",
        op_kwargs={"RegistryId": registry_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of registries that you have created, with minimal registry information. Registries in the Deleting status will not be included in the results. Empty results will be returned if there are no registries available.

    Args:
        max_results(int, optional): Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page. Defaults to None.
        next_token(str, optional): A continuation token, if this is a continuation call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.registry.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.registry.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="list_registries",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, registry_id: Dict, description: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing registry which is used to hold a collection of schemas. The updated properties relate to the registry, and do not modify any of the schemas within the registry.

    Args:
        registry_id(Dict): This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).
        description(str): A description of the registry. If description is not provided, this field will not be updated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.registry.update(ctx, registry_id=value, description=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.registry.update registry_id=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_registry",
        op_kwargs={"RegistryId": registry_id, "Description": description},
    )
