"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    mapping: List,
    source: Dict,
    sinks: List = None,
    location: Dict = None,
    language: str = None,
    additional_plan_options_map: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets code to perform a specified mapping.

    Args:
        mapping(List): The list of mappings from a source table to target tables.
        source(Dict): The source table.
        sinks(List, optional): The target tables. Defaults to None.
        location(Dict, optional): The parameters for the mapping. Defaults to None.
        language(str, optional): The programming language of the code to perform the mapping. Defaults to None.
        additional_plan_options_map(Dict, optional): A map to hold additional optional key-value parameters. Currently, these key-value pairs are supported:    inferSchema  —  Specifies whether to set inferSchema to true or false for the default script generated by an Glue job. For example, to set inferSchema to true, pass the following key value pair:  --additional-plan-options-map '{"inferSchema":"true"}'   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.plan.get(ctx, mapping=value, source=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.plan.get mapping=value, source=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_plan",
        op_kwargs={
            "Mapping": mapping,
            "Source": source,
            "Sinks": sinks,
            "Location": location,
            "Language": language,
            "AdditionalPlanOptionsMap": additional_plan_options_map,
        },
    )
