"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    partition_input: Dict,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new partition.

    Args:
        catalog_id(str, optional): The Amazon Web Services account ID of the catalog in which the partition is to be created. Defaults to None.
        database_name(str): The name of the metadata database in which the partition is to be created.
        table_name(str): The name of the metadata table in which the partition is to be created.
        partition_input(Dict): A PartitionInput structure defining the partition to be created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.partition.init.create(
                ctx, database_name=value, table_name=value, partition_input=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.partition.init.create database_name=value, table_name=value, partition_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_partition",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "PartitionInput": partition_input,
        },
    )


async def delete(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    partition_values: List,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified partition.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partition to be deleted resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database in which the table in question resides.
        table_name(str): The name of the table that contains the partition to be deleted.
        partition_values(List): The values that define the partition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.partition.init.delete(
                ctx, database_name=value, table_name=value, partition_values=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.partition.init.delete database_name=value, table_name=value, partition_values=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_partition",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "PartitionValues": partition_values,
        },
    )


async def get(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    partition_values: List,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about a specified partition.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partition in question resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the partition resides.
        table_name(str): The name of the partition's table.
        partition_values(List): The values that define the partition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.partition.init.get(
                ctx, database_name=value, table_name=value, partition_values=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.partition.init.get database_name=value, table_name=value, partition_values=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_partition",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "PartitionValues": partition_values,
        },
    )


async def get_all(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    catalog_id: str = None,
    expression: str = None,
    next_token: str = None,
    segment: Dict = None,
    max_results: int = None,
    exclude_column_schema: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the partitions in a table.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partitions in question reside. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database where the partitions reside.
        table_name(str): The name of the partitions' table.
        expression(str, optional): An expression that filters the partitions to be returned. The expression uses SQL syntax similar to the SQL WHERE filter clause. The SQL statement parser JSQLParser parses the expression.   Operators: The following are the operators that you can use in the Expression API call:  =  Checks whether the values of the two operands are equal; if yes, then the condition becomes true. Example: Assume 'variable a' holds 10 and 'variable b' holds 20.  (a = b) is not true.  < >  Checks whether the values of two operands are equal; if the values are not equal, then the condition becomes true. Example: (a < > b) is true.  >  Checks whether the value of the left operand is greater than the value of the right operand; if yes, then the condition becomes true. Example: (a > b) is not true.  <  Checks whether the value of the left operand is less than the value of the right operand; if yes, then the condition becomes true. Example: (a < b) is true.  >=  Checks whether the value of the left operand is greater than or equal to the value of the right operand; if yes, then the condition becomes true. Example: (a >= b) is not true.  <=  Checks whether the value of the left operand is less than or equal to the value of the right operand; if yes, then the condition becomes true. Example: (a <= b) is true.  AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL  Logical operators.    Supported Partition Key Types: The following are the supported partition keys.    string     date     timestamp     int     bigint     long     tinyint     smallint     decimal    If an type is encountered that is not valid, an exception is thrown.  The following list shows the valid operators on each type. When you define a crawler, the partitionKey type is created as a STRING, to be compatible with the catalog partitions.   Sample API Call: . Defaults to None.
        next_token(str, optional): A continuation token, if this is not the first call to retrieve these partitions. Defaults to None.
        segment(Dict, optional): The segment of the table's partitions to scan in this request. Defaults to None.
        max_results(int, optional): The maximum number of partitions to return in a single response. Defaults to None.
        exclude_column_schema(bool, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.partition.init.get_all(
                ctx, database_name=value, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.partition.init.get_all database_name=value, table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_partitions",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "Expression": expression,
            "NextToken": next_token,
            "Segment": segment,
            "MaxResults": max_results,
            "ExcludeColumnSchema": exclude_column_schema,
        },
    )


async def update(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    partition_value_list: List,
    partition_input: Dict,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a partition.

    Args:
        catalog_id(str, optional): The ID of the Data Catalog where the partition to be updated resides. If none is provided, the Amazon Web Services account ID is used by default. Defaults to None.
        database_name(str): The name of the catalog database in which the table in question resides.
        table_name(str): The name of the table in which the partition to be updated is located.
        partition_value_list(List): List of partition key values that define the partition to update.
        partition_input(Dict): The new partition object to update the partition to. The Values property can't be changed. If you want to change the partition key values for a partition, delete and recreate the partition.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.partition.init.update(
                ctx,
                database_name=value,
                table_name=value,
                partition_value_list=value,
                partition_input=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.partition.init.update database_name=value, table_name=value, partition_value_list=value, partition_input=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_partition",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "PartitionValueList": partition_value_list,
            "PartitionInput": partition_input,
        },
    )
