"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    partition_index: Dict,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a specified partition index in an existing table.

    Args:
        catalog_id(str, optional): The catalog ID where the table resides. Defaults to None.
        database_name(str): Specifies the name of a database in which you want to create a partition index.
        table_name(str): Specifies the name of a table in which you want to create a partition index.
        partition_index(Dict): Specifies a PartitionIndex structure to create a partition index in an existing table.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.partition.index.create(
                ctx, database_name=value, table_name=value, partition_index=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.partition.index.create database_name=value, table_name=value, partition_index=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_partition_index",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "PartitionIndex": partition_index,
        },
    )


async def delete(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    index_name: str,
    catalog_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified partition index from an existing table.

    Args:
        catalog_id(str, optional): The catalog ID where the table resides. Defaults to None.
        database_name(str): Specifies the name of a database from which you want to delete a partition index.
        table_name(str): Specifies the name of a table from which you want to delete a partition index.
        index_name(str): The name of the partition index to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.partition.index.delete(
                ctx, database_name=value, table_name=value, index_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.partition.index.delete database_name=value, table_name=value, index_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_partition_index",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "IndexName": index_name,
        },
    )


async def get_all(
    hub,
    ctx,
    database_name: str,
    table_name: str,
    catalog_id: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the partition indexes associated with a table.

    Args:
        catalog_id(str, optional): The catalog ID where the table resides. Defaults to None.
        database_name(str): Specifies the name of a database from which you want to retrieve partition indexes.
        table_name(str): Specifies the name of a table for which you want to retrieve the partition indexes.
        next_token(str, optional): A continuation token, included if this is a continuation call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.partition.index.get_all(
                ctx, database_name=value, table_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.partition.index.get_all database_name=value, table_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_partition_indexes",
        op_kwargs={
            "CatalogId": catalog_id,
            "DatabaseName": database_name,
            "TableName": table_name,
            "NextToken": next_token,
        },
    )
