"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    input_record_tables: List,
    parameters: Dict,
    role: str,
    description: str = None,
    glue_version: str = None,
    max_capacity: float = None,
    worker_type: str = None,
    number_of_workers: int = None,
    timeout: int = None,
    max_retries: int = None,
    tags: Dict = None,
    transform_encryption: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Glue machine learning transform. This operation creates the transform and all the necessary parameters to train it. Call this operation as the first step in the process of using a machine learning transform (such as the FindMatches transform) for deduplicating data. You can provide an optional Description, in addition to the parameters that you want to use for your algorithm. You must also specify certain parameters for the tasks that Glue runs on your behalf as part of learning from your data and creating a high-quality machine learning transform. These parameters include Role, and optionally, AllocatedCapacity, Timeout, and MaxRetries. For more information, see Jobs.

    Args:
        name(str): The unique name that you give the transform when you create it.
        description(str, optional): A description of the machine learning transform that is being defined. The default is an empty string. Defaults to None.
        input_record_tables(List): A list of Glue table definitions used by the transform.
        parameters(Dict): The algorithmic parameters that are specific to the transform type used. Conditionally dependent on the transform type.
        role(str): The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. The required permissions include both Glue service role permissions to Glue resources, and Amazon S3 permissions required by the transform.    This role needs Glue service role permissions to allow access to resources in Glue. See Attach a Policy to IAM Users That Access Glue.   This role needs permission to your Amazon Simple Storage Service (Amazon S3) sources, targets, temporary directory, scripts, and any libraries used by the task run for this transform.  .
        glue_version(str, optional): This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see Glue Versions in the developer guide. Defaults to None.
        max_capacity(float, optional): The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the Glue pricing page.   MaxCapacity is a mutually exclusive option with NumberOfWorkers and WorkerType.   If either NumberOfWorkers or WorkerType is set, then MaxCapacity cannot be set.   If MaxCapacity is set then neither NumberOfWorkers or WorkerType can be set.   If WorkerType is set, then NumberOfWorkers is required (and vice versa).    MaxCapacity and NumberOfWorkers must both be at least 1.   When the WorkerType field is set to a value other than Standard, the MaxCapacity field is set automatically and becomes read-only. When the WorkerType field is set to a value other than Standard, the MaxCapacity field is set automatically and becomes read-only. Defaults to None.
        worker_type(str, optional): The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.   For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.   For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.   For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.    MaxCapacity is a mutually exclusive option with NumberOfWorkers and WorkerType.   If either NumberOfWorkers or WorkerType is set, then MaxCapacity cannot be set.   If MaxCapacity is set then neither NumberOfWorkers or WorkerType can be set.   If WorkerType is set, then NumberOfWorkers is required (and vice versa).    MaxCapacity and NumberOfWorkers must both be at least 1.  . Defaults to None.
        number_of_workers(int, optional): The number of workers of a defined workerType that are allocated when this task runs. If WorkerType is set, then NumberOfWorkers is required (and vice versa). Defaults to None.
        timeout(int, optional): The timeout of the task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). Defaults to None.
        max_retries(int, optional): The maximum number of times to retry a task for this transform after a task run fails. Defaults to None.
        tags(Dict, optional): The tags to use with this machine learning transform. You may use tags to limit access to the machine learning transform. For more information about tags in Glue, see Amazon Web Services Tags in Glue in the developer guide. Defaults to None.
        transform_encryption(Dict, optional): The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms can access user data encrypted in Amazon S3 using KMS. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.transform.create(
                ctx, name=value, input_record_tables=value, parameters=value, role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.transform.create name=value, input_record_tables=value, parameters=value, role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="create_ml_transform",
        op_kwargs={
            "Name": name,
            "Description": description,
            "InputRecordTables": input_record_tables,
            "Parameters": parameters,
            "Role": role,
            "GlueVersion": glue_version,
            "MaxCapacity": max_capacity,
            "WorkerType": worker_type,
            "NumberOfWorkers": number_of_workers,
            "Timeout": timeout,
            "MaxRetries": max_retries,
            "Tags": tags,
            "TransformEncryption": transform_encryption,
        },
    )


async def delete(hub, ctx, transform_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an Glue machine learning transform. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by Glue. If you no longer need a transform, you can delete it by calling DeleteMLTransforms. However, any Glue jobs that still reference the deleted transform will no longer succeed.

    Args:
        transform_id(str): The unique identifier of the transform to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.transform.delete(ctx, transform_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.transform.delete transform_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="delete_ml_transform",
        op_kwargs={"TransformId": transform_id},
    )


async def get(hub, ctx, transform_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets an Glue machine learning transform artifact and all its corresponding metadata. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by Glue. You can retrieve their metadata by calling GetMLTransform.

    Args:
        transform_id(str): The unique identifier of the transform, generated at the time that the transform was created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.transform.get(ctx, transform_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.transform.get transform_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_ml_transform",
        op_kwargs={"TransformId": transform_id},
    )


async def get_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    filter_: Dict = None,
    sort: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a sortable, filterable list of existing Glue machine learning transforms. Machine learning transforms are a special type of transform that use machine learning to learn the details of the transformation to be performed by learning from examples provided by humans. These transformations are then saved by Glue, and you can retrieve their metadata by calling GetMLTransforms.

    Args:
        next_token(str, optional): A paginated token to offset the results. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        filter_(Dict, optional): The filter transformation criteria. Defaults to None.
        sort(Dict, optional): The sorting criteria. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.transform.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.transform.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_ml_transforms",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filter": filter_,
            "Sort": sort,
        },
    )


async def list_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    filter_: Dict = None,
    sort: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Retrieves a sortable, filterable list of existing Glue machine learning transforms in this Amazon Web Services account, or the resources with the specified tag. This operation takes the optional Tags field, which you can use as a filter of the responses so that tagged resources can be retrieved as a group. If you choose to use tag filtering, only resources with the tags are retrieved.

    Args:
        next_token(str, optional): A continuation token, if this is a continuation request. Defaults to None.
        max_results(int, optional): The maximum size of a list to return. Defaults to None.
        filter_(Dict, optional): A TransformFilterCriteria used to filter the machine learning transforms. Defaults to None.
        sort(Dict, optional): A TransformSortCriteria used to sort the machine learning transforms. Defaults to None.
        tags(Dict, optional): Specifies to return only these tagged resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.transform.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.transform.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="list_ml_transforms",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filter": filter_,
            "Sort": sort,
            "Tags": tags,
        },
    )


async def update(
    hub,
    ctx,
    transform_id: str,
    name: str = None,
    description: str = None,
    parameters: Dict = None,
    role: str = None,
    glue_version: str = None,
    max_capacity: float = None,
    worker_type: str = None,
    number_of_workers: int = None,
    timeout: int = None,
    max_retries: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing machine learning transform. Call this operation to tune the algorithm parameters to achieve better results. After calling this operation, you can call the StartMLEvaluationTaskRun operation to assess how well your new parameters achieved your goals (such as improving the quality of your machine learning transform, or making it more cost-effective).

    Args:
        transform_id(str): A unique identifier that was generated when the transform was created.
        name(str, optional): The unique name that you gave the transform when you created it. Defaults to None.
        description(str, optional): A description of the transform. The default is an empty string. Defaults to None.
        parameters(Dict, optional): The configuration parameters that are specific to the transform type (algorithm) used. Conditionally dependent on the transform type. Defaults to None.
        role(str, optional): The name or Amazon Resource Name (ARN) of the IAM role with the required permissions. Defaults to None.
        glue_version(str, optional): This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more information, see Glue Versions in the developer guide. Defaults to None.
        max_capacity(float, optional): The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the Glue pricing page.  When the WorkerType field is set to a value other than Standard, the MaxCapacity field is set automatically and becomes read-only. Defaults to None.
        worker_type(str, optional): The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.   For the Standard worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.   For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1 executor per worker.   For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1 executor per worker.  . Defaults to None.
        number_of_workers(int, optional): The number of workers of a defined workerType that are allocated when this task runs. Defaults to None.
        timeout(int, optional): The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this transform can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). Defaults to None.
        max_retries(int, optional): The maximum number of times to retry a task for this transform after a task run fails. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.transform.update(ctx, transform_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.transform.update transform_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="update_ml_transform",
        op_kwargs={
            "TransformId": transform_id,
            "Name": name,
            "Description": description,
            "Parameters": parameters,
            "Role": role,
            "GlueVersion": glue_version,
            "MaxCapacity": max_capacity,
            "WorkerType": worker_type,
            "NumberOfWorkers": number_of_workers,
            "Timeout": timeout,
            "MaxRetries": max_retries,
        },
    )
