"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, transform_id: str, task_run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels (stops) a task run. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as part of various machine learning workflows. You can cancel a machine learning task run at any time by calling CancelMLTaskRun with a task run's parent transform's TransformID and the task run's TaskRunId.

    Args:
        transform_id(str): The unique identifier of the machine learning transform.
        task_run_id(str): A unique identifier for the task run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.task_run.cancel(
                ctx, transform_id=value, task_run_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.task_run.cancel transform_id=value, task_run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="cancel_ml_task_run",
        op_kwargs={"TransformId": transform_id, "TaskRunId": task_run_id},
    )


async def get(hub, ctx, transform_id: str, task_run_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details for a specific task run on a machine learning transform. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as part of various machine learning workflows. You can check the stats of any task run by calling GetMLTaskRun with the TaskRunID and its parent transform's TransformID.

    Args:
        transform_id(str): The unique identifier of the machine learning transform.
        task_run_id(str): The unique identifier of the task run.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.task_run.get(ctx, transform_id=value, task_run_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.task_run.get transform_id=value, task_run_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_ml_task_run",
        op_kwargs={"TransformId": transform_id, "TaskRunId": task_run_id},
    )


async def get_all(
    hub,
    ctx,
    transform_id: str,
    next_token: str = None,
    max_results: int = None,
    filter_: Dict = None,
    sort: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of runs for a machine learning transform. Machine learning task runs are asynchronous tasks that Glue runs on your behalf as part of various machine learning workflows. You can get a sortable, filterable list of machine learning task runs by calling GetMLTaskRuns with their parent transform's TransformID and other optional parameters as documented in this section. This operation returns a list of historic runs and must be paginated.

    Args:
        transform_id(str): The unique identifier of the machine learning transform.
        next_token(str, optional): A token for pagination of the results. The default is empty. Defaults to None.
        max_results(int, optional): The maximum number of results to return. . Defaults to None.
        filter_(Dict, optional): The filter criteria, in the TaskRunFilterCriteria structure, for the task run. Defaults to None.
        sort(Dict, optional): The sorting criteria, in the TaskRunSortCriteria structure, for the task run. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.task_run.get_all(ctx, transform_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.task_run.get_all transform_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="get_ml_task_runs",
        op_kwargs={
            "TransformId": transform_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filter": filter_,
            "Sort": sort,
        },
    )
