"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(hub, ctx, transform_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts a task to estimate the quality of the transform.  When you provide label sets as examples of truth, Glue machine learning uses some of those examples to learn from them. The rest of the labels are used as a test to estimate quality. Returns a unique identifier for the run. You can call GetMLTaskRun to get more information about the stats of the EvaluationTaskRun.

    Args:
        transform_id(str): The unique identifier of the machine learning transform.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.glue.ml.evaluation_task_run.start(ctx, transform_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.glue.ml.evaluation_task_run.start transform_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="glue",
        operation="start_ml_evaluation_task_run",
        op_kwargs={"TransformId": transform_id},
    )
